<?php

namespace App\Http\Controllers\FCControllers\Survey;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
Use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Exceptions\NoTypeDetectedException;
use Log;
use DB;
use Auth;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Option;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\Wallet;
use App\Imports\FCImports\Participant;
use App\Models\fcmodels\Response;

class MobiParticipantController extends Controller
{
    //
    public function index($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
        $participants =[];
        $tablecolumns = [];
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dbtable = 'participant_'.$ids.'_'.$survey['id'];
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participants = DB::select("SELECT * FROM $dbtable"); 
        }
        
        
        return view('fcviews.mobisurvey.participants.index',compact('wallet','survey','dbtable','tablecolumns','participants'));
    }
    //create tale
    public function create(Request $request)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }

        $dbtable = 'participant_'.$ids.'_'.$request->survey;
        Schema::dropIfExists($dbtable);
            
        //then create the schema
        $cols = $request->thechoices;
        $def = $request->survey;
        Schema::create($dbtable, function (Blueprint $table) use ($cols,$def) {
            $table->string('id');
            $table->integer('survey_id')->length(11)->unsigned()->default($def);
            $table->string('phone');
            foreach($cols as $col){
                $table->longText($col['field'])->nullable();
            }
            $table->integer('status')->length(1)->unsigned()->default(0);
            $table->integer('language')->length(1)->unsigned()->default(0);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
        });
        //create csv
        $checkarray=count(Schema::getColumnListing($dbtable));

        $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
        //get the table columns
        $tablecolumns=array_slice($tablecolumns1,2);
          
          $file = fopen("sample/".$dbtable.'.csv',"w");
          
          fputcsv($file, $tablecolumns);
          
          fclose($file);
          // end write to csv
        return $dbtable.' created';
    }
    //store contact
    public function store(Request $request)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $dbtable = 'participant_'.$ids.'_'.$request->survey;
        //generate ID
        $finalID=DB::select("SELECT MAX(id) AS participant_id from $dbtable");
                        
        $finalid=$finalID[0]->participant_id;
        if(empty($finalid))
        {
            $id = $ids.'_'.$request->survey.'_1';
        }
        else
        {
            $pid = explode('_',$finalid);
            $addone = $pid[2]+1;
            $id = $ids.'_'.$request->survey.'_'.$addone;
        }
        $arr = ['id' => $id];
        $arr_combined = array_merge($arr,array_slice($request->toArray(),2));
        
        $insert =DB::table($dbtable)->insert($arr_combined);
        return  back()->with('success','Participant Added succesfully!');
    }
        //update contact
    public function update(Request $request)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $dbtable = 'participant_'.$ids.'_'.$request->survey;
        
        $arr = ['id' => $id];
        $arr_combined = array_merge(array_slice($request->toArray(),2));
        
        $insert =DB::table($dbtable)->where('id',$request->id)->update($arr_combined);
        return  back()->with('success','Participant updated succesfully!');
    }
    //import participants
    public function import(Request $request)
    {
        request()->validate([
            'file' => 'required|max:2000',
         ],
         [
             'file.required' => 'Please select an Excel or CSV File',
             'file.max' => 'Please select a file with size under 2MBs',
         ]);
            if(Auth::check())
            {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
            }
           
            else{
                return abort('401');
            }
            $dbtable = 'participant_'.$ids.'_'.$request->survey;
            $path = $request->file;
            $message = $request->message;
            try{
                
                Excel::import(new Participant($dbtable), $path);
        
                return back();
            }
            catch (NoTypeDetectedException $e) {
                return redirect()->back()->with('failure', 'Wrong File format Uploaded!'); 
                
            }
    }
    
    
    //return view completed participants
    public function completedparticipants($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
      
        else{
            return abort('401');
        }
        
        
        
        
             $survey = Survey::findOrFail($id);
        $i=0;
        $questions = Question::where('survey_id',$id)->where('type','Closed')->get();
                // 
        //get labels and count
         $dbtable = 'participant_'.$ids.'_'.$id;
         $participantsnotparticipated = DB::select("SELECT count(*) as count FROM $dbtable where language='0' and status='0'"); 
         $participantsnotparticipated=$participantsnotparticipated[0]->count;
         $participantscompleted = DB::select("SELECT * FROM $dbtable where language !='0' and status='1'"); 
             
         $incomplete_arr=[];
         $complete_arr=[];
         foreach($participantscompleted as $participant){
             $languageid=$participant->language;
             $participantid= $participant->id;
             $question= Question::where('language_id',$languageid)->max('id');
             $responses= Response::where('participant_id',$participantid)->where('question_id',$question)->get()->toArray();
             
              if(!empty($responses)){
                 array_push($complete_arr,$responses);
              }
              else
              {
                 array_push($incomplete_arr,$responses);
              }
        }
        $complete = count($complete_arr);
        $incomplete = count($incomplete_arr); 
        
        
        
        $participants =[];
        $tablecolumns = [];
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dbtable = 'participant_'.$ids.'_'.$survey['id'];
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participants = DB::select("SELECT * FROM $dbtable where language !='0' and status='1' "); 
        }
        
        
        return view('fcviews.mobisurvey.participants.index',compact('wallet','survey','dbtable','tablecolumns','participants'));
    }
    
    
    
    //return view participants Not completed 
    public function partiallycompletedparticipants($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
        
        
        
        $survey = Survey::findOrFail($id);
        $i=0;
        $questions = Question::where('survey_id',$id)->where('type','Closed')->get();
                // 
        //get labels and count
         $dbtable = 'participant_'.$ids.'_'.$id;
         $participantsnotparticipated = DB::select("SELECT count(*) as count FROM $dbtable where language='0' and status='0'"); 
         $participantsnotparticipated=$participantsnotparticipated[0]->count;
         $participantscompleted = DB::select("SELECT * FROM $dbtable where language !='0' and status='1'"); 
             
         $incomplete_arr=[];
         $complete_arr=[];
         foreach($participantscompleted as $participant){
             $languageid=$participant->language;
             $participantid= $participant->id;
             $question= Question::where('language_id',$languageid)->max('id');
             $responses= Response::where('participant_id',$participantid)->where('question_id',$question)->get()->toArray();
             
              if(!empty($responses)){
                 array_push($complete_arr,$responses);
              }
              else
              {
                 array_push($incomplete_arr,$responses);
              }
        }
        $complete = count($complete_arr);
        $incomplete = count($incomplete_arr); 
        
        
        
        $participants =[];
        $tablecolumns = [];
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dbtable = 'participant_'.$ids.'_'.$survey['id'];
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            
            $participants = DB::select("SELECT * FROM $dbtable where language !='0' and status='1' "); 
        }

        return view('fcviews.mobisurvey.participants.index',compact('wallet','survey','dbtable','tablecolumns','participants'));
    }
    
    
    
    
      //return view participants Not participated 
    public function participantsnotparticipated($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
        
        
        
        $survey = Survey::findOrFail($id);
        $i=0;
        $questions = Question::where('survey_id',$id)->where('type','Closed')->get();
                // 
        //get labels and count
         $dbtable = 'participant_'.$ids.'_'.$id;
         $participantsnotparticipated = DB::select("SELECT count(*) as count FROM $dbtable where language='0' and status='0'"); 
         $participantsnotparticipated=$participantsnotparticipated[0]->count;
         $participantscompleted = DB::select("SELECT * FROM $dbtable where language !='0' and status='1'"); 
             
         $incomplete_arr=[];
         $complete_arr=[];
         foreach($participantscompleted as $participant){
             $languageid=$participant->language;
             $participantid= $participant->id;
             $question= Question::where('language_id',$languageid)->max('id');
             $responses= Response::where('participant_id',$participantid)->where('question_id',$question)->get()->toArray();
             
              if(!empty($responses)){
                 array_push($complete_arr,$responses);
              }
              else
              {
                 array_push($incomplete_arr,$responses);
              }
        }
        $complete = count($complete_arr);
        $incomplete = count($incomplete_arr); 
        
        
        
        $participants =[];
        $tablecolumns = [];
        $survey = Survey::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $dbtable = 'participant_'.$ids.'_'.$survey['id'];
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participants = DB::select("SELECT * FROM $dbtable  where language='0' and status='0' "); 
        }
        
        
        return view('fcviews.mobisurvey.participants.index',compact('wallet','survey','dbtable','tablecolumns','participants'));
    }
    
    ///delete part
    public function delete($id)
    {
        $arr = explode('_',$id);
        
        $dbtable = 'participant_'.$arr[0].'_'.$arr[1];
        DB::table($dbtable)->where('id',$id)->delete();
    }
    
}
