<?php

namespace App\Http\Controllers\FCControllers;
Use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use App\Models\fcmodels\Import;
use Auth;
use App\Models\fcmodels\CountryRate;
use App\Models\fcmodels\Country;
use App\Models\fcmodels\Sms_Template;
use App\Imports\MessageSmscontactssImport;

use App\Imports\FCImports\SmscontactssImport;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;

class SmscontactexceluploadsController extends Controller
{ 
    public function index()
    {

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
           $smstemplates = Sms_Template::where('organization_id',$id)->get();
        
                $mycountries = CountryRate::where('shopId',$api_account)->with('rateCountry')->get();
        //return $mycountries;
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
            $contacts = Import::where('status','0')->where('message',NULL)->where('organization_id',$id)->get();//->with('ImportOrg')->get();
            //return  $contacts;
            
            return view('fcviews.smscontactexceluploads.index',compact('contacts','smstemplates','wallet','mycountries'));
 
}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    //import clients to db
    public function import(Request $request) 
    {

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }


         request()->validate([
            'file' => 'required|max:2000'
         ],
         [
             'file.required' => 'Please select a file first',
             'file.max' => 'Please select a file with size under 2MBs',
             'file.mimes' => 'Accepted file types are Excel with extensions [*.xlsx,*.xls,*.csv]',
         ]
    );
        $path = $request->file;
        

        try {
                Excel::import(new MessageSmscontactssImport($id), $path);
                // Your query here
            } catch (\Illuminate\Database\QueryException $e) {
                
                return redirect()->back()->with('failure', $e->errorInfo[2]); 
            } catch (\Exception $e) {
                
            }
     
       
        return redirect()->back(); 
       // return $request->file;
    }

    

    //store
    public function storeContact(Request $request)
    {
        $request->validate([
       
            'import_name' => 'required',
    
                    
                ]);
        $data = new Import();
        $data->import_name = $request->import_name;
        $data->phone = $request->phone;
        $data->group_id = $request->group_id;

        $data->organization_id = Auth::user()->organization_id;


        // return $data;
        $data->save ();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::user()->organization_id;
        
        $adminLog->save();
        

        $sms = Bulksms();   
        return view('fcviews.smscomposer.index',compact('sms'));


        return response()->json($data);
    }





 //edit
 public function editContacts(Request $request)

 {

  //  try
    { 
        request()->validate([
            'name'=> 'required',
  
        ]);
        return $request;
    //current customer 
    $id=$request->id;
    $contactsdets = Contact::where('contact_id',$id)->get();
    //update
    $data = Contact::findOrFail($id);
   
    $data->name = $request->get('name');
    $data->phone = $request->get('phone');
    $data->group_id = $request->get('group_id');



    // log data
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::user()->organization_id;
    ;
    $adminLog->save();
    $data->save();

      return redirect()->back()
        ->with('success','Contacts Edited Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }








 //delete
 public function deleteContact(Request $request,$id){
    //find user details to delete
    $Contact = Contact::where('contact_id',$id)->get();
    //set delete
    $deleteContact = Contact::find($id);
    $deleteContact->delete();
    //set logging
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .Auth::user()->organization_id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = Auth::user()->organization_id; 
    $adminLog->save();
}



//edit
 public function editImports(Request $request)

 {

  //  try
    { 
        request()->validate([
            'import_name'=> 'required',
  
        ]);
       // return $request;
    //current customer 
    $id=$request->import_id;
    
    $contactsdets = Import::where('import_id',$id)->get();
    //update
   
    $data = Import::findOrFail($id);
    
    $data->import_name = $request->get('import_name');
    $data->phone = $request->get('phone');
    $data->message = $request->get('message');

 

    // log data
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::user()->organization_id;
    ;
    $adminLog->save();
    $data->save();

      return redirect()->back()
        ->with('success','Contacts Edited Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }



 //delete
 public function DeleteExcelUpload(Request $request,$id){
    //find user details to delete
    $Contact = Import::where('import_id',$id)->get();
    //set delete
    $deleteContact = Import::find($id);
    $deleteContact->delete();
    //set logging
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .Auth::user()->organization_id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = Auth::user()->organization_id; 
    $adminLog->save();
}






}

