<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use App\Setting;
use Auth;
use App\Charts\BMCharts\UserChart;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\CustomerClientPayment;
use App\Models\bmmodels\CustomerClient;
use App\Models\bmmodels\CustomerUser;
use App\Models\bmmodels\CustomerGroup;
use App\Models\bmmodels\ClientBatch;
use App\Models\bmmodels\CustomerWallet;
use App\Models\bmmodels\CustomerAuth;
use App\Models\bmmodels\AuditLog;
use Exception;
use ErrorException;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    //return admin login
    public function adminLogin()
    {
        return view('bmviews.auth.admin-login.index');
    }
    //return user login
    public function userLogin()
    {
        return view('bmviews.auth.otp-login');
    }
    //return customer login
    public function customerLogin()
    {
        return view('bmviews.auth.customer-login.index');
    }

    //return admin dashboard
    public function admin()
    {
        return view('bmviews.admin-dashboard');
    }
    //return cus dashboard
    public function customer()
    {
        return view('bmviews.customer-dashboard');
    }
    //return user dashboard
    public function user()
    {
        if(Auth::user()->user_type == 'organization_user')
        {
            if(Auth::user()->cust_status == 1)
            {
                if(Auth::user()->cust_user_status == 1)
                {
                    try
                    {
                    $today = date('Y-m-d');
                    $uid = Auth::user()->cust_user_id;
                    $id = Auth::user()->customer_cust_id;
                    //usr activity
                    $activities = AuditLog::where('audit_module','User' )->where('user_id',$uid)->latest()->take(5)->get();
                    //get customers
                    $users = CustomerUser::where('customer_cust_id',$id)->count();
                    $myclients = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->count();
                    $mygroups = CustomerGroup::where('customer_cust_id',$id)->where('cust_group_status',1)->count();
                    $mybatches = ClientBatch::where('client_batch_customer_id',$id)->groupBy('client_batch_id')->count();
                    
                    //get wallet id
                    $wallet = CustomerWallet::where('customer_cust_id',$id)->pluck('cust_wallet_id');
                    $clients = CustomerClient::where('customer_cust_id',$id)->pluck('cust_client_id');
                    $client_batchs = ClientBatch::where('client_batch_customer_id',$id)->pluck('id');
                    //get total income and expenditure
                    $income = CustomerWalletTransaction::where('cust_wallet_cust_wallet_id',$wallet)->where('wallet_trans_status',1)->sum('wallet_trans_amount');
                    $today_income = CustomerWalletTransaction::where('cust_wallet_cust_wallet_id',$wallet)->where('wallet_trans_status',1)->where('created_at','LIKE',$today."%")->sum('wallet_trans_amount');
                    $expenditure = CustomerClientPayment::whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)->orWhere('customer_cust_id',$id)->where('client_pay_status', 1)->sum('client_pay_amount');
                    $today_expenditure = CustomerClientPayment::where('client_pay_status', 1)->where('created_at','LIKE',$today."%")->whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)->orWhere('customer_cust_id',$id)->sum('client_pay_amount');
                    //chart
                    $total = $income+$expenditure;
    
                    $borderColors = [ "#30ba35", "#f25961" ];
                    $fillColors = [ "#5ad85e", "#f57a81" ];
                    
                    $chart = new UserChart;
                    $chart->minimalist(true);
                            $chart->labels(['Income','Spend']);
                            $chart->dataset('Income & Expenditure', 'doughnut',[$income,$expenditure])
                            ->color($borderColors)
                            ->backgroundcolor($fillColors);
                            
    
                    return view('bmviews.user-dashboard',compact('income','expenditure','users','myclients','mygroups','mybatches','today_income','chart','activities','today_expenditure'));
                    }
                    catch(ErrorException $e)
                    {
                        abort(500, $e->getMessage());
                    }
                }
                else
                {
                    return redirect()->route('login')->with('failure','Sorry! Your account is inactive');
                }
            }
            else
            {
                return redirect()->route('login')->with('failure','Sorry! Your Organization account is inactive');
            }
            
        }
        else
        {
            return redirect()->route('login');
        }
        
    }
  

}
