<?php

namespace App\Http\Controllers\BMControllers;
use Illuminate\Http\Request;
use App\Models\bmmodels\Setting;

class ServiceCredentialController extends Controller
{
      //set the b2ccredentialssettings when the b2c request is initaited
      public function b2cSettings(){
        //access the model that stores the credentials
        $settings=Setting::where('setting_type','mpesa')->get();
        //if count is greater than 0 then proceed and retrieve the key
        $setting_status=0;
        if(($settings->count())>0){
        //set the config values
        $m_key=$settings[0]['setting_key'];
        $m_value=$settings[0]['setting_value'];

        \Config::set('outpost.m_key',encrypt($m_key));
        \Config::set('outpost.m_sc',encrypt($m_value));
        $setting_status=1;
        }
        else{
          $setting_status=0;
        }
        //return the status if value exists
        return $setting_status;
          
    }
     //set the b2ccredentialssettings when the b2c request is initaited
     public function mobiskySettings(){
      //access the model that stores the credentials
      $settings=Setting::where('setting_type','mobisky1')->get();
      //if count is greater than 0 then proceed and retrieve the key
      $setting_status=0;
      if(($settings->count())>0){
      //set the config values
      $sms_username=$settings[0]['setting_key'];
      $sms_password=$settings[0]['setting_value'];

      \Config::set('outpost.sms_username',encrypt($sms_username));
      \Config::set('outpost.sms_password',encrypt($sms_password));
      $setting_status=1;
      }
      else{
        $setting_status=0;
      }
      //return the status if value exists
      return $setting_status;
        
  }
}
