<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use Auth;
use Hash;
use App\Models\bmmodels\AuditLog;
use Exception;
use  ErrorException;

class HistoryController extends Controller
{
    
    /**
    * Display a listing of the resource.
    *
    * @return \Illuminate\Http\Response
    */
   public function index($id)
   {
            if(Auth::user()->user_type == 'organization')
            {
            try{
                $uid = Auth::user()->bulk_cust_id;
                $AuditLogs = AuditLog::where('audit_module','Customer' )->where('user_id',$uid)->orderByDesc('audit_log_id')->get();
            }
            catch(Exception $e)
            {
                abort(500, $e->getMessage());
            }
            }
            else if(Auth::user()->user_type == 'organization_user')
            {
            try{
                $uid = Auth::user()->cust_user_id;
                $AuditLogs = AuditLog::where('audit_module','User' )->where('user_id',$uid)->orderByDesc('audit_log_id')->get();
            }
            catch(Exception $e)
            {
                abort(500, $e->getMessage());
            }
            }
            else
            {
            try
            {
                $uid = Auth::guard('admin')->user()->admin_id;
                $AuditLogs = AuditLog::where('audit_module','Admin')->where('user_id',$uid)->orderByDesc('audit_log_id')->get();
            }
            catch(Exception $e)
            {
                abort(500, $e->getMessage());
            }
            }
        
            ///$AuditLog = AuditLog::find($id);
            // return view('history.index',compact('customerGroup'));
            try
            {
            return view('bmviews.history.index', compact('AuditLogs'));
            }
            catch(Exception $e)
            {
                abort(500, $e->getMessage());
            }
   }
}