<?php

namespace App\EloquentFilters\CustomerClientPayment;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;

class PhoneFilter extends Filter
{
    /**
     * Apply the condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        return $builder->whereHas('ClientPaymentClient', function($query) use($value) {
            return $query->where('client_pay_id', '=', substr($value,-9));
        });
    }
}
