<?php

namespace App\EloquentFilters\CustomerClientPayment;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;

class GroupFilter extends Filter
{
    /**
     * Apply the condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        return $builder->whereHas('ClientPaymentClient', function($query1) use($value) {
            $query1->whereHas('ClientClientGroup', function($query2) use($value) {
                $query2->whereHas('ClientGroupGroup', function($query3) use($value) {
                    $query3->where('cust_group_id','=',$value);
                });
            });
        });
    }
}
